<?php

defined('_JEXEC') or die;

$app             = JFactory::getApplication();
$doc             = JFactory::getDocument();
$user            = JFactory::getUser();
$this->language  = $doc->language;
$this->direction = $doc->direction;

// Getting params from template
$params = $app->getTemplate(true)->params;

// Detecting Active Variables
$option   = $app->input->getCmd('option', '');
$view     = $app->input->getCmd('view', '');
$layout   = $app->input->getCmd('layout', '');
$task     = $app->input->getCmd('task', '');
$itemid   = $app->input->getCmd('Itemid', '');
$sitename = $app->get('sitename');

// Add JavaScript Frameworks
JHtml::_('bootstrap.framework');
$doc->addScript($this->baseurl . '/templates/' . $this->template . '/js/template.js');

// Add Stylesheets
$doc->addStyleSheet($this->baseurl . '/templates/' . $this->template . '/css/template.css');

// Load optional RTL Bootstrap CSS
JHtml::_('bootstrap.loadCss', false, $this->direction);
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo $this->language; ?>" lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>">
<head>
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<jdoc:include type="head" />
</head>

<body>

	<!-- Body -->
	<div class="body">
		<div class="container<?php echo ($params->get('fluidContainer') ? '-fluid' : ''); ?>">
			<!-- Header -->
			<header class="header" role="banner">
				<div class="header-inner clearfix">

					<div class="header-search pull-right">
						<jdoc:include type="modules" name="position-0" style="none" />
					</div>
				</div>
                
                <jdoc:include type="modules" name="logo" style="xhtml" />
                <jdoc:include type="modules" name="headerImage" style="xhtml" />
                <jdoc:include type="modules" name="topMenu" style="xhtml" />
                
			</header>
            
            <jdoc:include type="modules" name="introText" style="xhtml" />
            
			
			<jdoc:include type="modules" name="banner" style="xhtml" />
			<div class="row-fluid">
				
				<main id="content" role="main">
					<jdoc:include type="message" />
					<jdoc:include type="component" />
				</main>
			    
			</div>
		
        		<jdoc:include type="modules" name="homeQuoteArea" style="xhtml" />
        
        </div>
	</div>
    
	<!-- Footer -->
	<footer class="footer">
		<div class="container">
			<jdoc:include type="modules" name="footer_top" style="xhtml" />
        </div>
        <div class="container">
            <jdoc:include type="modules" name="footer_bottom" style="xhtml" />
		</div>
    </footer>
        
<script>
		jQuery(document).ready(function(){
		
		//About Page
		jQuery('#communicationInfo p').mouseover(function(){
			jQuery(this).css('background-color','#38639f');
		});
		
		jQuery('#communicationInfo p').mouseleave(function(){
			jQuery(this).css('background-color','#4e7bba');
		});
		
		//Capabilities Page		
		jQuery('#currentCapabilities li').mouseover(function(){
			jQuery(this).css('background-color','#38639f');
		});
		
		jQuery('#currentCapabilities li').mouseleave(function(){
			jQuery(this).css('background-color','#4e7bba');
		});				
		});	
</script>
     
<!-- SMOOTH SCROLL FUCNTION -->   
<script type="text/javascript" language="javascript">
jQuery(function() {
  jQuery('a[href*=#]:not([href=#])').click(function() {
    if (location.pathname.replace(/^\//,'') == this.pathname.replace(/^\//,'') && location.hostname == this.hostname) {
      var target = jQuery(this.hash);
      target = target.length ? target : jQuery('[name=' + this.hash.slice(1) +']');
      if (target.length) {
        jQuery('html,body').animate({
          scrollTop: target.offset().top
        }, 1000);
        return false;
      }
    }
  });
});
</script>
        
</body>
</html>