<?php
require_once(__DIR__.'/../files/extension.php');
require_once(__DIR__.'/../files/tree_orm.php');
require_once(__DIR__.'/../files/fairy_orm.php');

/**
 * Generated by PHPUnit_SkeletonGenerator on 2013-02-07 at 10:14:10.
 */
class ORM_Test extends PHPUnit_Framework_TestCase
{

	/**
	 * @var Expression_Database
	 */
	protected $object;

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 */
	protected function setUp()
	{
		
		$this->db_file = tempnam(sys_get_temp_dir(), 'test.sqlite');
		$this->conf_file = tempnam(sys_get_temp_dir(), 'test.conf');
		file_put_contents($this->db_file, '');
		$db = new PDO('sqlite:'.$this->db_file);
		$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$db->exec("CREATE TABLE fairies(id INT PRIMARY_KEY,name VARCHAR(255),tree_id INT)");
		$db->exec("CREATE TABLE trees(id INT PRIMARY_KEY,name VARCHAR(255),protector_id INT)");
		$db->exec("CREATE TABLE friends(fairy_id INT,friend_id INT)");

		$db->exec("INSERT INTO fairies(id,name,tree_id) VALUES (1,'Tinkerbell',1)");
		$db->exec("INSERT INTO fairies(id,name,tree_id) VALUES (2,'Trixie',2)");

		$db->exec("INSERT INTO trees(id,name,protector_id) VALUES (1,'Oak',2)");
		$db->exec("INSERT INTO trees(id,name,protector_id) VALUES (2,'Willow',2)");

		$db->exec("INSERT INTO friends(fairy_id,friend_id) VALUES (1,2)");

		$this->pixie = $this->getMock('\PHPixie\Pixie',array('find_file'));
		$this->pixie->expects($this->any())
                 ->method('find_file')
                 ->will($this->returnValue($this->conf_file));
		$this->pixie->db = new \PHPixie\DB($this->pixie);
		$this->pixie-> orm = new \PHPixie\ORM($this->pixie);
				 
		$this->pixie->config->set('db.orm.connection', 'sqlite:'.$this->db_file);
		$this->pixie->config->set('db.orm.driver', 'pdo');

		$this->fairies = new \Model\Fairy($this->pixie);
		$this->trees = new \Model\Tree($this->pixie);
		$this->object = $this->pixie-> orm;
	}
	
	protected function tearDown()
	{	
		$db = $this->pixie->db->get('orm');
		$db->conn = null;
		unlink($this->db_file);
		unlink($this->conf_file);
	}
	
	public function testGet() {
		$this->assertEquals('Model\Fairy', get_class($this->object->get('fairy')));
		$this->assertEquals('Model\Tree', get_class($this->object->get('tree')));
		$this->assertEquals(1, $this->object->get('fairy',1)->id);
	}
	
	public function testResult() {
		$this->assertEquals('PHPixie\ORM\Result', get_class($this->object->result('fairy',null)));
	}
	

	
}
