<?php

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.0 on 2013-02-10 at 16:36:42.
 */
class RoterTest extends PHPUnit_Framework_TestCase
{

	/**
	 * @var Router
	 */
	protected $object;

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 */
	protected function setUp()
	{
		$this->object=new \PHPixie\Router(new \PHPixie\Pixie);
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 */
	protected function tearDown()
	{

	}

	/**
	 * @covers Route::get
	 * @todo   Implement testGet().
	 */
	public function testGet()
	{
		$except = false;
		$this->object->add(new \PHPixie\Route('/', 'a', 'b', array()));
		try {
			$this->object->get('c');
		} catch (\Exception $e) {
			$except = true;
		}
		$this->assertEquals(true, $except);
	}

	/**
	 * @covers Route::match
	 * @todo   Implement testMatch().
	 */
	public function testMatchFunc()
	{
		$this->object->add(new \PHPixie\Route('/', 'func', function() {
				return array('action' => 'index');
			}, array('controller' => 'home')));
		$route = $this->object->match('/test');
		$this->assertEquals('func',  $route['route']->name);
		$this->assertEquals('index', $route['params']['action']);
		$this->assertEquals('home', $route['params']['controller']);
	}

	/**
	 * @covers Route::match
	 * @todo   Implement testMatch().
	 */
	public function testMatchDefault()
	{
		$this->object->add(new \PHPixie\Route('/', 'default', '(/<controller>(/<action>(/<id>)))', array(
			'controller' => 'home',
			'action' => 'index'
		)));
		$route = $this->object->match('/');
		$this->assertEquals('default', $route['route']->name);
		$this->assertEquals('index', $route['params']['action']);
		$this->assertEquals('home', $route['params']['controller']);

		$route = $this->object->match('/test');
		$this->assertEquals('default', $route['route']->name);
		$this->assertEquals('index', $route['params']['action']);
		$this->assertEquals('test', $route['params']['controller']);

		$route = $this->object->match('/test/act');
		$this->assertEquals('default', $route['route']->name);
		$this->assertEquals('act', $route['params']['action']);
		$this->assertEquals('test', $route['params']['controller']);

		$route = $this->object->match('/test/act/8');
		$this->assertEquals('default', $route['route']->name);
		$this->assertEquals('act', $route['params']['action']);
		$this->assertEquals('test', $route['params']['controller']);
		$this->assertEquals(8, $route['params']['id']);
	}

	/**
	 * @covers Route::match
	 * @todo   Implement testMatch().
	 */
	public function testMatchCustom()
	{
		$this->object->add(new \PHPixie\Route('/', 'default', array('/<alpha><num>', array(
				'alpha' => '[a-z]*',
				'num' => '[0-9]*'
			)), array(
			'controller' => 'home',
			'action' => 'index'
		)));
		$route = $this->object->match('/test123');
		$this->assertEquals('default', $route['route']->name);
		$this->assertEquals('index', $route['params']['action']);
		$this->assertEquals('home', $route['params']['controller']);
		$this->assertEquals('test', $route['params']['alpha']);
		$this->assertEquals(123, $route['params']['num']);
	}
	
	public function testMatchMethod() {
		$this->object->add(new \PHPixie\Route('/', 'get', '/url', array(
			'controller' => 'home',
			'action' => 'get'
		), 'GeT'));
		$this->object->add(new \PHPixie\Route('/', 'post', '/url', array(
			'controller' => 'home',
			'action' => 'get'
		), array('PosT')));
		$route = $this->object->match('/url', 'GEt');
		$this->assertEquals('get', $route['route']->name);
		$route = $this->object->match('/url', 'POST');
		$this->assertEquals('post', $route['route']->name);
	}


}
