<?php
namespace Controller {

	class TestController extends \PHPixie\Controller {
		public function action_index(){}
	}
}

namespace {



	/**
	 * Generated by PHPUnit_SkeletonGenerator on 2013-02-06 at 16:12:22.
	 */
	class requestTest extends PHPUnit_Framework_TestCase
	{

		/**
		 * @var Request
		 */
		protected $object;

		/**
		 * Sets up the fixture, for example, opens a network connection.
		 * This method is called before a test is executed.
		 */
		protected function setUp()
		{
			$this->pixie = new \PHPixie\Pixie();
			$this->pixie->app_namespace = "";
			$this->object = new \PHPixie\Request(
				$this->pixie,
				new \PHPixie\Route('/','test',array(),array()),
				'GET', 
				array('fairy_post' => 'Trixie', 'xss' => 'a<div></div>','xss_arr'=>array(array('a<div></div>'))), 
				array('fairy_get' => 'Trixie', 'xss' => 'a<div></div>', 'xss_arr' => array(array('a<div></div>'))), 
				array('controller' => 'TestController', 'action' => 'index', 'fairy_param' => 'Trixie'),
				array('fairy_server' => 'Trixie', 'HTTP_HOST' => 'phpixie.com', 'REQUEST_URI' => '/test/?test=test'),
				array('fairy_cookie' => 'Trixie')
			);
		}

		/**
		 * Tears down the fixture, for example, closes a network connection.
		 * This method is called after a test is executed.
		 */
		protected function tearDown()
		{

		}
		
		/**
		 * @covers Request::filter_xss
		 * 
		 */
		public function testFilter_Xss()
		{
			$this->assertNull($this->object->filter_xss(null));
			$this->assertEquals($this->object->filter_xss('a<div></div>'), 'a');
			$this->assertEquals(current(current($this->object->filter_xss(array(array('a<div></div>'))))), 'a');
		}

		/**
		 * @covers Request::get
		 * @todo   Implement testGet().
		 */
		public function testGet()
		{
			$this->assertEquals($this->object->get('fairy_get'), 'Trixie');
			$this->assertEquals($this->object->get('bogus', 'default'), 'default');
			$this->assertEquals($this->object->get('xss'), 'a');
			$this->assertEquals($this->object->get('xss', null, false), 'a<div></div>');
			$this->assertEquals(current(current($this->object->get('xss_arr', null, false))), 'a<div></div>');
			$this->assertEquals(current(current($this->object->get('xss_arr'))), 'a');
		}

		/**
		 * @covers Request::post
		 * @todo   Implement testPost().
		 */
		public function testPost()
		{
			$this->assertEquals($this->object->post('fairy_post'), 'Trixie');
			$this->assertEquals($this->object->post('bogus', 'default'), 'default');
			$this->assertEquals($this->object->post('xss'), 'a');
			$this->assertEquals($this->object->post('xss', null, false), 'a<div></div>');
			$this->assertEquals(current(current($this->object->post('xss_arr', null, false))), 'a<div></div>');
			$this->assertEquals(current(current($this->object->post('xss_arr'))), 'a');
		}

		/**
		 * @covers Request::server
		 * @todo   Implement testServer().
		 */
		public function testServer()
		{
			$this->assertEquals($this->object->server('fairy_server'), 'Trixie');
			$this->assertEquals($this->object->server('bogus', 'default'), 'default');
		}

		/**
		 * @covers Request::param
		 * @todo   Implement testParam().
		 */
		public function testParam()
		{
			$this->assertEquals($this->object->param('fairy_param'), 'Trixie');
			$this->assertEquals($this->object->param('bogus', 'default'), 'default');
		}

		/**
		 * @covers Request::execute
		 * @todo   Implement testExecute().
		 */
		public function testExecute()
		{
			$this->object->execute();
			$this->assertEquals('Trixie', $this->pixie->cookie->get('fairy_cookie'));
		}

		/**
		 * @covers Request::url
		 */
		public function testUrl()
		{
			$this->assertEquals('http://phpixie.com/test/', $this->object->url());
			$this->assertEquals('http://phpixie.com/test/?test=test', $this->object->url(true));
			$this->object = new \PHPixie\Request($this->pixie, $this->object->route, 'GET', array(), array(), array(),
				array('HTTPS' => 'on','HTTP_HOST'=>'phpixie.com','REQUEST_URI'=>'/test/?test=test')
			);
			$this->assertEquals('https://phpixie.com/test/', $this->object->url());
			$this->assertEquals('https://phpixie.com/test/?test=test', $this->object->url(true));
			
		}
		/**
		 * @covers Request::execute
		 * @todo   Implement testExecute().
		 */
		public function testExecuteException()
		{
			$req = new \PHPixie\Request(
				$this->pixie,
				new \PHPixie\Route('/', 'test',array(),array()),
				'GET', 
				array('fairy_post' => 'Trixie', 'xss' => 'a<div></div>','xss_arr'=>array(array('a<div></div>'))), 
				array('fairy_get' => 'Trixie', 'xss' => 'a<div></div>', 'xss_arr' => array(array('a<div></div>'))), 
				array('controller' => 'bogus', 'action' => 'index', 'fairy_param' => 'Trixie'),
				array('fairy_server' => 'Trixie','HTTP_HOST'=>'phpixie.com','REQUEST_URI'=>'/test/?test=test')
			);
			$except = false;
			try {
				$req->execute();
			} catch (Exception $e) {
				$except = true;
			}
			$this->assertEquals($except, true);
		}

	}
}
