<?php
require_once(ROOT.'/vendor/phpixie/core/classes/PHPixie/Controller.php');
class TestController extends \PHPixie\Controller {
	public $counter = 0;
	public function before() {
		$this->counter++;
	}
	public function action_index() {
		$this->counter++;
	}
	public function after() {
		$this->counter++;
	}
}

/**
 * Generated by PHPUnit_SkeletonGenerator on 2013-02-05 at 16:39:57.
 */
class ControllerTest extends PHPUnit_Framework_TestCase
{

	/**
	 * @var Controller
	 */
	protected $object;

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 */
	protected function setUp()
	{
		$this->pixie = new \PHPixie\Pixie;
		$this->object = new TestController($this->pixie);
	}
	
	public function testRedirect() {
		$this->object->redirect('http://google.com');
		$this->assertEquals(false,$this->object->execute);
		$this->assertContains('Location: http://google.com', $this->object->response->headers);
	}
	public function testRun()
	{
		$this->object->run('index');
		$this->assertEquals($this->object->counter, 3);
	}

	public function testException()
	{
		$except = false;
		try {
			$this->object->run('bogus');
		} catch (\PHPixie\Exception\PageNotFound $e) {
			$except = true;
		}
		$this->assertEquals($except, true);
	}

}
