<?php
/**
 * Generated by PHPUnit_SkeletonGenerator on 2013-02-06 at 09:17:25.
 */
class configTest extends PHPUnit_Framework_TestCase
{

	/**
	 * @var Config
	 */
	protected $object;

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 */
	protected function setUp()
	{
		$this->file = $file = tempnam(sys_get_temp_dir(), 'view');
		file_put_contents($file, "<?php return ".var_export(array(
				'trees' => array(
					'oak' => array(
						'fairy' => 'Tinkerbell'
					)
				)
				), true).';');
		$pixie = $this->getMock("\\PHPixie\\Pixie", array('find_file'));
		$pixie->expects($this->once())
                 ->method('find_file')
                 ->will($this->returnValue($this->file));
		$this->object = new \PHPixie\Config($pixie);
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 */
	protected function tearDown()
	{
		unlink($this->file);
	}

	/**
	 * @covers $this->object->get_group
	 * @todo   Implement testGet_group().
	 */
	public function testGet_group()
	{
		$group = $this->object->get_group('test');
		$this->assertArrayHasKey('trees', $group);
		$this->assertArrayHasKey('oak', $group['trees']);
		$this->assertArrayHasKey('fairy', $group['trees']['oak']);
		$this->assertEquals($group['trees']['oak']['fairy'], 'Tinkerbell');
	}

	/**
	 * @covers $this->object->get
	 * @todo   Implement testGet().
	 */
	public function testGet()
	{
		$this->assertEquals($this->object->get('test.trees.oak.fairy'), 'Tinkerbell');
		$this->assertEquals($this->object->get('test.trees.oak.fairies', 'default'), 'default');
	}

	/**
	 * @covers $this->object->set
	 * @todo   Implement testSet().
	 */
	public function testSet()
	{
		$this->object->set('test.trees.oak.second_fairy', 'Trixie');
		$this->assertEquals($this->object->get('test.trees.oak.second_fairy'), 'Trixie');
	}

	/**
	 * @covers $this->object->write
	 * @todo   Implement testWrite().
	 */
	public function testWrite()
	{
		$this->object->set('test.trees.oak.second_fairy', 'Trixie');
		$this->object->write('test');
		$group = include($this->file);
		$this->assertArrayHasKey('trees', $group);
		$this->assertArrayHasKey('oak', $group['trees']);
		$this->assertArrayHasKey('second_fairy', $group['trees']['oak']);
		$this->assertEquals($group['trees']['oak']['second_fairy'], 'Trixie');
	}
	
	public function testEmpty()
	{
		file_put_contents($this->file, '');
		$this->assertEquals($this->object->get('test.trees.oak.fairies', 'default'), 'default');
		$this->object->set('test.trees.oak.second_fairy', 'Trixie');
		$this->assertEquals($this->object->get('test.trees.oak.second_fairy'), 'Trixie');
		$this->object->write('test');
		$group = $this->object->get('test');
		$this->assertArrayHasKey('trees', $group);
		$this->assertArrayHasKey('oak', $group['trees']);
		$this->assertArrayHasKey('second_fairy', $group['trees']['oak']);
		$this->assertEquals($group['trees']['oak']['second_fairy'], 'Trixie');
	}

}
